KasperskyLab.AddRunner("ca", function (ns, session) 
{
	var m_callFunction = function(){};
	var m_bodySended = false;
	var m_subscribedAttribute = "ca_" + ns.GetCurrentTime();
	var m_lastSendedTime = 0;
	var m_accountElements = [];
	function ToBase64(value)
	{
		if (ns.IsDefined(window.btoa))
			return btoa(value);

		var Base64Alphabit = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
		var plain = value;
		var padLength = 0;
		if (plain.length % 3)
		{
			padLength = 3 - plain.length % 3;
			for (var i = 0; i < padLength; ++i)
				plain += '\0';
		}
		var result = "";
		for (var i = 0; i < plain.length; i += 3)
		{
			var byte1 = plain.charCodeAt(i);
			var byte2 = plain.charCodeAt(i + 1);
			var byte3 = plain.charCodeAt(i + 2);

			var temp = byte1 << 16 | byte2 << 8 | byte3;

			var sixBit1 = temp>>18 & 0x3f;
			var sixBit2 = temp>>12 & 0x3f;
			var sixBit3 = temp>>6 & 0x3f;
			var sixBit4 = temp & 0x3f;

			result += Base64Alphabit.charAt(sixBit1) + Base64Alphabit.charAt(sixBit2) + Base64Alphabit.charAt(sixBit3) + Base64Alphabit.charAt(sixBit4);
		}
		if (padLength > 0)
		{
			result = result.slice(0, result.length - padLength);
			for (var i = 0; i < padLength; ++i)
				result += "=";
		}
		return result;
	}
	function CallService(commandName, argObject, resultCallback)
	{
		m_callFunction("ca." + commandName, [ns.JSONStringify(argObject)], resultCallback);
	}
	function ProcessChilds(childNodes)
	{
		for (var i = 0; i < childNodes.length; ++i)
		{
			var element = childNodes[i];
			if (element.nodeType !== Node.ELEMENT_NODE)
				continue;

			if (!IsVisible(element))
				element.setAttribute("wfd-invisible", true);
			else
				ProcessChilds(element.childNodes);
		}
	}
	function OnKeyDown()
	{
		if (m_bodySended)
			return;
		try
		{
			ProcessChilds(document.body.childNodes);
		}
		catch (e)
		{
			ns.SessionLog(e);
		}
		m_bodySended = true;
		CallService("onInput", {dom: document.documentElement.innerHTML}, OnInputCallback);
	}
	function GetElements(root, tag, type)
	{
		if (root.querySelectorAll)
			return root.querySelectorAll(tag + "[type='"+type+"']");

		var result = [];
		var childrens = root.getElementsByTagName(tag);
		for (var i = 0; i < childrens.length; i++) 
		{
			if (childrens[i].type.toLowerCase() == type) 
				result.push(childrens[i]);
		}
		return result;
	}
	function IsVisible(element) 
	{
		var style = window.getComputedStyle ? window.getComputedStyle(element) : element.currentStyle;
		return style.display !== "none";
	}

	function GetSingleButton(parentElement)
	{
		var buttons = GetElements(parentElement, 'button', 'submit');
		if (buttons && buttons.length > 0) 
			return buttons;
		buttons = parentElement.getElementsByTagName("button");
		if (buttons && buttons.length === 1) 
			return buttons[0];
		var result = [];
		for (var i = 0; i < buttons.length; i++) 
			if (IsVisible(buttons[i])) 
				result.push(buttons[i]);
		return result.length === 1 ? result[0] : [];
	}
	function IsSubscribedElement(element)
	{
		return element[m_subscribedAttribute];
	}
	function SetSubscribedElement(element)
	{
		element[m_subscribedAttribute] = true;
	}

	function SetInputHandler(onInputData, isAccountElement)
	{
		for (var i = 0; i < onInputData.accountFieldSelectors.length; ++i)
		{
			var element = document.querySelector(onInputData.accountFieldSelectors[i]);

			if (!element)
				continue;

			SetEventHandlers(element);

			if (isAccountElement)
				m_accountElements.push(element);
		}
	}

	function OnInputCallback(result, args)
	{
		if (!args || args.length < 1)
			return;

		SetInputHandler(ns.JSONParse(args[0]), true);

		if (args.length > 1)
			SetInputHandler(ns.JSONParse(args[1]), false);
	}
	function OnSubmit()
	{
		var currentTime = ns.GetCurrentTime();
		if (currentTime - 500 < m_lastSendedTime)
			return; 

		var accounts = [];
		for (var i = 0; i < m_accountElements.length; ++i)
		{
			var accountElement = m_accountElements[i];
			if (accountElement.value)
				accounts.push(ToBase64(accountElement.value));
		};
		if (accounts.length > 0)
		{
			CallService("onAccount", {accounts:accounts});
			m_lastSendedTime = currentTime;
		}
		else
		{
			ns.SessionLog("CA: OnSubmit with no data occure");
		}
	}
	function SetEnterKeyEventListener(element)
	{
		ns.AddEventListener(element, "keydown", 
			function(e)
			{
				if (e.keyCode === 13)
					OnSubmit(); 
			});
	}

	function SetButtonClickEventListener(element)
	{
		ns.AddEventListener(element, "click", OnSubmit);
	}
	function SetButtonsEventHandlers(submitButtons)
	{
		for (var i = 0; i < submitButtons.length; ++i)
		{
			var button = submitButtons[i];
			if (!IsSubscribedElement(button))
			{
				SetButtonClickEventListener(button);
				SetEnterKeyEventListener(button);
				SetSubscribedElement(button);
			}
		}
	}
	function SetEventHandlers(accountElement)
	{
		if (IsSubscribedElement(accountElement))
			return;
		SetEnterKeyEventListener(accountElement);
		if (accountElement.form)
		{
			var parentForm = accountElement.form;
			if (!IsSubscribedElement(parentForm))
			{
				ns.AddEventListener(parentForm, "submit", OnSubmit);

				var tmp = parentForm.submit;
				parentForm.submit = function()
				{
					OnSubmit();
					tmp.apply(parentForm);
				}

				SetSubscribedElement(parentForm);
			}

			var submitButtons = GetElements(parentForm, "input", "submit");

			if (submitButtons.length > 0)
				SetButtonsEventHandlers(submitButtons);
			else
				SetButtonsEventHandlers([GetSingleButton(parentForm)]);
		}
		else
		{
			SetButtonsEventHandlers([GetSingleButton(document)]);
		}
	}

	function OnError(){}
	function OnPing() 
	{
		return ns.MaxRequestDelay;
	}
	function OnInitializeCallback(activatePlugin, registerMethod, callFunction)
	{
		m_callFunction = callFunction;
		activatePlugin('ca', OnPing, OnError);
		ns.AddEventListener(document, "keydown", OnKeyDown);
	}
	function InitializePlugin()
	{
		session.InitializePlugin(OnInitializeCallback);
	}
	InitializePlugin();
});
